
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 17:25:55 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_AES.c#1:csrc:6
   *  \author adams
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */



/************* Include Files ****************/

/* .............. CRYS level includes ................. */

#include "DX_VOS_Mem.h"
#include "CRYS.h"
#include "dx_hw_defs.h"
#include "mng_host_op_code.h"
#include "extApp_mng.h"
/* .............. LLF level includes .................. */

 
/******************************** Defines ******************************/

/************************ MACROS ***************************************/

/************************ Global Data ***********************************/

/************* Private function prototype *******************************/


/************************ Public Functions ******************************/


/*This function configure the SEP timer                              */
/*The function parameters:                                           */
/*TimeInKTicks - The time in kTicks. It is done because the timer    */
/*is set in ticks and not seconds and in order to give a larger      */
/* range than 32 bit number                                          */
/* Any value other than 0x0 enables the timer, 0 disables the Timer  */
/* Since the counter has only 32 bit register for value the software */
/* is implementing a software counter that works in larger range     */

DxUint32_t DX_SEP_MNG_TimerConfigure(DxUint32_t TimeInKTicks)
{
 
   return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_TIMER_CONFIGURE_OP_CODE, 1,
							    /* PARAMETERS: */
								TimeInKTicks );
   
}/* END OF DX_SEP_MNG_TimerConfigure */   
                         
/**************************************************************/
/* This function allows the external application to configure */
/* Direct Data Access register in order to access different   */
/* External memories ranges                                   */
/* Parameters:												  */
/* offset - offset of the external memory range from the SEP  */
/* range (0x60000000). The type is Uint16 because only the 16 */
/* MSB are being used (which means that the ranges are change */
/* in blocks of 64KB                                          */
/**************************************************************/
DxUint8_t * DX_SEP_MNG_SetExtMemAccess(DxUint32_t PeripheralAddr)
{

   return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_SET_EXT_MEM_ACCESS_OP_CODE, 1,
							    /* PARAMETERS: */
								PeripheralAddr );
   
}/* END OF DX_SEP_MNG_SetExtMemAccess */


/**************************************************************/
/* This functions copies one of the verifications keys to the */
/* user buffer.                                               */
/**************************************************************/

DxUint32_t DX_SEP_GetVerificationOTPKey(DX_SEP_EXTAPP_OTP_KEY_TYPES keyIndex, DxUint8_t    *KeyBuffer_ptr, DxUint32_t KeyBufferLen)
{
   return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_GET_VER_OTP_KEY_OP_CODE, 3,
							    /* PARAMETERS: */
								keyIndex,
								KeyBuffer_ptr,
								KeyBufferLen);
}

/*****************************************************************/
/* This functions send ack signal from the Discretix application */
/*****************************************************************/

DxUint32_t DX_SEP_SendExtIntAck(void)
{
   return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_SEND_EXT_INT_ACK_OP_CODE, 0);
}


/**********************************************/
/* The function returns the LCS               */
/**********************************************/
DxError_t DX_MNG_GetLCS(DxUint32_t    *LCS_ptr)
{
   return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_GET_LCS_OP_CODE, 1,
							    /* PARAMETERS: */
								LCS_ptr);
    
}

/*****************************************************************/
/* The function returns the Dx SST workspace address and size    */
/* Parameters:                                                   */
/* DxByte_t   **aWorkspace_ptr - buffer for the address.         */
/* DxUint32_t *aWorkspaceSizeInBytes_ptr - buffer for the size   */
/*****************************************************************/
DxError_t DX_SEP_MNG_SSTGetWorkspaceParams(DxByte_t			**aWorkspace_ptr,
										   DxUint32_t		*aWorkspaceSizeInBytes_ptr)
{
   return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_SST_GET_WS_PARAMS_OP_CODE, 2,
							    /* PARAMETERS: */
								aWorkspace_ptr,
                                aWorkspaceSizeInBytes_ptr);
}    


/*****************************************************************/
/* The function is used to read the caller ID from HOST memory   */
/* Parameters:                                                   */
/* DxByte_t   * callerId_ptr - buffer for the address.           */
/* DxUint32_t  callerIdLen - buffer for the size                 */
/*****************************************************************/
DxUint32_t DX_SEP_GetCallerId(DxUint8_t *callerId_ptr, DxUint32_t callerIdLen)
{
   return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_GET_CALLER_ID_OP_CODE, 2,
							    /* PARAMETERS: */
								callerId_ptr,
                                callerIdLen);

}


/*
*   @brief This function is used for reseting and configuring the 3 cache counters. 
*   Each counter can be one of the 9 options defined in the enumerator DX_CC_MNG_CacheCounterType_t.       
*
*   @param[in] cfgCnt1 - cache counter configuration for counter1. 
*   @param[in] cfgCnt2 - cache counter configuration for counter2. 
*   @param[in] cfgCnt3 - cache counter configuration for counter3. 
*   Returns:  Status of the operation.
*/

DxError_t DX_CC_MNG_ConfigureAndResetCacheCounters(DX_CC_MNG_CacheCounterType_t       cacheType,
                                                   DX_CC_MNG_CacheCounterConfigType_t cfgCnt1,
                                                   DX_CC_MNG_CacheCounterConfigType_t cfgCnt2,
                                                   DX_CC_MNG_CacheCounterConfigType_t cfgCnt3)
{
   return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_SET_CACHE_CNTS_CONFIG_ID_OP_CODE, 3,
							    /* PARAMETERS: */
                                cacheType,
                                cfgCnt1,
                                cfgCnt2,
                                cfgCnt3);
}


/*
*   @brief This function is used for reading the 3 cache counters. 
*   The read is not reseting the counters so counter can be read few times        
*   during the tests flow without reconfiguration.
*
*
*   @param[in] cnt1Val - buffer for counter1. 
*   @param[in] cnt2Val - buffer for counter2. 
*   @param[in] cnt3Val - buffer for counter3. 
*   Returns:  Status of the operation.
*/

DxError_t DX_CC_MNG_GetCacheCounters(DX_CC_MNG_CacheCounterType_t       cacheType,
                                     DxUint32_t                         *cnt1Val,
                                     DxUint32_t                         *cnt2Val,
                                     DxUint32_t                         *cnt3Val)
{
   return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_READ_CACHE_CNTS_ID_OP_CODE, 4,
							    /* PARAMETERS: */
                                cacheType,
                                cnt1Val,
                                cnt2Val,
                                cnt3Val);
}
